#!/usr/local/bin/perl

package Cookie;

sub get_expire{
    local( $days_later ) = shift;
    ( $sec, $min, $hour, $mday, $mon, $year, $wday ) = gmtime( time + $days_later*60*60*24 );
    $mon = ( "Jan", "Feb", "Mar", "Apr", "May", "Jun" , "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" )[$mon];
    $wday = ( "Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat" )[$wday];
    sprintf( "$wday, %2.2d-$mon-%4.4d %2.2d:%2.2d:%2.2d GMT" , $mday, $year+1900, $hour, $min, $sec );
}

sub do_escape{
    local( $src ) = shift;
    $src =~ s/([^0-9a-zA-Z])/sprintf( "%%%02lx", unpack( "C", $1 ) )/eg;
    $src =~ s/ /+/g;
    $src;
}

sub put{
    local( $key, $value, $valid_term ) = @_;
    local( $expire );
	$value = &do_escape($value);
    $expire = &get_expire( $valid_term );
    "Set-Cookie: " . "$key=$value; " . "expires=$expire; ";
}

sub get{
    local( $cookie, %cookie, $key, $value );
    $cookie = $ENV{'HTTP_COOKIE'};
    foreach( split( /;\s*/, $cookie ) ){
        ( $key, $value ) = split( '=', $_ );
        $value =~ s/\+/ /g;
        $value =~ s/%([\da-f][\da-f])/pack( "C", hex( $1 ) )/egi;
        &jcode'convert( *value, 'euc' );
        $cookie{$key} = $value;
    }
    %cookie;
}

1;

